<?php

namespace App\Http\Controllers\Site\Result;


use App\Models\Academic\AcademicResultCombineType;

use App\Models\Site\Result\SiteIndividualCombineSubjectResultStore;
use App\Models\Site\Result\SiteStudentCombineResultDetail;
use App\Models\Site\Result\SiteResultCombineSetting;
use App\Models\Site\Result\SiteResultSystemSetting;
use App\Models\Site\Result\SiteStudentPrimaryResultDetail;
use App\Models\Student\StudentHistory;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Controllers\ProjectController;
use Response;
use App\Models\Academic\AcademicSubject;

class SiteBaseCombineResultGenerateController extends ProjectController
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');

    }

    public function index()
    {
        $viewType = 'Site Result Setting Page';

        return view('default.admin.layouts.master', compact('viewType'));
//        return view('default.admin.site.result.site-base-result-generate', compact('viewType'));
    }



    //============================Combine Result Generate====================================


    public function getSiteBaseCombineResultTypeListForResultGenerate(Request $request){

        $data = $request->all();

        $getStudentIDs=StudentHistory::where('academic_year_id', $request->academic_year_id)
        ->where('academic_class_id', $request->academic_class_id)
        ->where('academic_shift_id', $request->academic_shift_id)
        ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
            return $query->where('academic_department_id', $data['academic_department_id']);
        })
        ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
            return $query->where('academic_class_group_id', $data['academic_class_group_id']);
        })
//            ->where('status', true)
        ->pluck('id');

        $resultSettingList = SiteResultCombineSetting::with(['academicResultCombineType'])
            ->where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->where('status', true)
            ->get();



        $academic_result_combine_type_Ids=$resultSettingList->pluck('academic_result_combine_type_id')->unique()->filter();
    

        $combine_array=[];
        foreach ($academic_result_combine_type_Ids as $key => $value){

            $check_primary_type_Ids=$resultSettingList->where('academic_result_combine_type_id', $value)
                ->pluck('academic_result_primary_type_id')
                ->unique()
                ->values();
               
            $siteExamDeclares_primary_type_ids=SiteStudentPrimaryResultDetail::whereIn('student_history_id', $getStudentIDs)
                ->whereIn('academic_result_primary_type_id', $check_primary_type_Ids)
                ->pluck('academic_result_primary_type_id')
                ->unique()
                ->values();
            //  dd($siteExamDeclares_primary_type_ids);
            if(count($check_primary_type_Ids)==count($siteExamDeclares_primary_type_ids)){
                $combine_list=$resultSettingList->where('academic_result_combine_type_id', $value)->first();
               
                $combine_array[]=$combine_list->academic_result_combine_type_id;
            }
        }
       
        $academic_result_combine_type=AcademicResultCombineType::whereIn('id', $combine_array)->get();

        $test_arr=Array();
        $resultlist=[];
        foreach ($academic_result_combine_type as $key => $value){

            $test_arr['loading_result_generate_image']=false;
            $resultlist[$key]=array_merge($test_arr, $value->toArray());
        }
        return $resultlist;
    }

  

    private function getStudenthistoryList(Request $request){


        $data = $request->all();
        $studentList = StudentHistory::select('id', 'user_id','student_roll_number','site_batch_detail_id')
            ->with(['student' => function ($q) {
                $q->with('latestPhoto');
                $q->select('id');
                $q->where('user_type', 'student');
            },
                'year', 'shift','department','batch','stClass','classGroup','session','section'
            ])
            ->where('academic_version_id', $request->academic_version_id)
            ->when(!empty($data['academic_year_id']), function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })
            ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['site_batch_detail_id']), function ($query) use ($data) {
                return $query->where('site_batch_detail_id', $data['site_batch_detail_id']);
            })
            ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            // ->when(!empty($data['status']), function ($query) use ($data) {
            //     return $query->where('status', $data['status']);
            // })
            //->where('status',true)
            ->orderBy('student_roll_number')
            ->orderBy('academic_section_id')
            ->orderBy('academic_class_id')
            ->orderBy('academic_department_id')
            ->orderBy('site_batch_detail_id')
            ->orderBy('academic_class_group_id')
            ->get();

    //    dd($studentList);
        return $studentList;
    
    }
        


    public function getSiteBaseCombineResultListForMaritList(Request $request){
        $data = $request->all();

        $studentList=$this->getStudenthistoryList($request);
        $student_ids=$studentList->pluck('id');
        $combine_result_type_ids=SiteStudentCombineResultDetail::whereIn('student_history_id', $student_ids)
            ->pluck('academic_result_combine_type_id')
            ->unique()
            ->filter()
            ->values();


        $combine_result_type_list=AcademicResultCombineType::whereIn('id', $combine_result_type_ids)
                ->get(['id', 'name']);

        return $combine_result_type_list;

    }


        public function createUpdateCombineMeritList(Request $request){

            $data=$request->all();

         //   dd($data);

            $student_list_ids = StudentHistory::where('academic_version_id', $request->academic_version_id)
                ->where('academic_year_id', $request->academic_year_id)
                ->where('academic_shift_id', $request->academic_shift_id)
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })
                ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })
                ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->when(count($data['academic_section_ids']), function ($query) use ($data) {
                    return $query->whereIn('academic_section_id', $data['academic_section_ids']);
                })
    //                ->where('status', true)
                ->pluck('id');


            $combineResultDetailList=SiteStudentCombineResultDetail::whereIn('student_history_id',$student_list_ids)
                ->where('academic_result_combine_type_id',$request->academic_result_combine_type_id)
                ->orderBy('gpa','DESC')
                ->orderBy('total_marks','DESC')
                ->get();
                
        $total_student=count($combineResultDetailList);


        

        // hight mark list


    //     $all_subject_mark_list=[];
    //     $kyess=0;
    //     foreach($combineResultDetailList as $combine_result){
    //         foreach(json_decode($combine_result->result_detail) as $subject){
    //          $all_subject_mark_list[$kyess]=$subject;
    //          $kyess++;
    //         }
    //     }

    //   $dependant_subject_id_list= collect($all_subject_mark_list)->pluck('exam_dependent_academic_subject_id')->unique()->values();

    //   foreach($dependant_subject_id_list as $dependant_subject_id){
    //    $subject_mark_list= collect($all_subject_mark_list)
    //     ->where('exam_dependent_academic_subject_id',$dependant_subject_id)
    //     ->sortByDesc('total_subject_mark')
    //     ->first();

    //    return $subject_mark_list;
    //   }

    

    //     $hight_marks_ids=SiteIndividualCombineSubjectResultStore::
    //             where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
    //             ->whereIn('student_history_id',$student_list_ids)
    //             ->where('status', true)
    //             ->pluck('exam_dependent_academic_subject_id')
    //             ->unique()
    //             ->filter();

    //         $hight_marks_list=[];
    //         foreach ($hight_marks_ids as $key => $value){
    //             $hight_marks_subject=SiteIndividualCombineSubjectResultStore::
    //                 where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
    //                 ->whereIn('student_history_id', $student_list_ids)
    //                 ->where('exam_dependent_academic_subject_id', $value)
    //                 ->where('status', true)
    //             //    ->orderBy('obtain_raw_total_marks', 'desc')
    //                 ->orderBy('obtain_total_marks_for_show', 'desc')
    //                // ->select('exam_dependent_academic_subject_id', 'obtain_raw_total_marks')
    //                 ->select('exam_dependent_academic_subject_id', 'obtain_total_marks_for_show','obtain_raw_total_marks')
    //                 ->first();
    
                  
    
    //             if($hight_marks_subject){
    //                 $hight_marks_list[]=$hight_marks_subject;
    //             }
    
    //         }


            $rank=1;
        foreach($combineResultDetailList as $result){

                $result->student_rank=$rank;
                $result->total_student=$total_student;
                $result->save();
                $rank++;
            
        }
    
       // $total_student=count($getUpdatedSiteStudentPrimaryResultDetail);

        return Response::json(['message' => 'Merit List Update Successfully!', 'mode' => 'Saved!'], 200);

        }


        public function createUpdateCombineTypeResultListForResultGenerate(Request $request){

            $data = $request->all();
    
    
            $studentIdsList=StudentHistory::where('academic_year_id', $request->academic_year_id)
                ->where('academic_class_id', $request->academic_class_id)
                ->where('academic_shift_id', $request->academic_shift_id)
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })
            //    ->where('id', 69925)
                ->pluck('id');
    
    
            $generateStudentRest=array_diff($studentIdsList->toArray(), $request->select_student_history_ids);
    
            if(count($generateStudentRest)>0){
                $tenStudentIDs=collect($generateStudentRest)->take(20);
            }else{
                $tenStudentIDs=[];
            }
    
            $generatedStudentIDs=array_merge($tenStudentIDs->toArray(), $request->select_student_history_ids);
    
    
            $classAllStudentlist=StudentHistory::whereIn('id', $studentIdsList)
                ->pluck('id');
    
            $CombineResultSettingList = SiteResultCombineSetting::with(['academicResultCombineType'])
                ->where('academic_version_id', $request->academic_version_id)
                ->where('academic_year_id', $request->academic_year_id)
                ->where('academic_shift_id', $request->academic_shift_id)
                ->where('academic_class_id', $request->academic_class_id)
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })
                ->where('academic_result_combine_type_id', $request->academic_result_combine_type_id)
                ->where('status', true)
                ->orderBy('show_position','ASC')
                ->get();
    
                if(!count($CombineResultSettingList)){
                    return Response::json('Undefine settings', 410);
                }
    
                $math_condition=$CombineResultSettingList[0]['math_condition'];
    
            $primary_result_type_list=[];
            foreach($CombineResultSettingList as $key=>$item){
                $primary_result_type_list[$key]['academic_result_primary_type_id']=$item->academic_result_primary_type_id;
                $primary_result_type_list[$key]['academic_result_primary_type_name']=$item->academicResultPrimaryType?$item->academicResultPrimaryType->name:'';
            }
            
    
    
            $primary_result_ids=$CombineResultSettingList->pluck('academic_result_primary_type_id')->unique();
        
            $combine_result_sett=$CombineResultSettingList->first();
    
            $primary_result_list=SiteStudentPrimaryResultDetail::with(['studentHistory'=>function ($query) {
        //    $primary_result_list=SiteStudentPrimaryResultDetailForTabulation::with(['studentHistory'=>function ($query) {
                $query->select('id', 'user_id', 'academic_shift_id', 'academic_class_id', 'academic_department_id',
                    'academic_session_id', 'academic_student_category_id',
                    'academic_class_group_id', 'academic_section_id', 'academic_year_id', 'student_roll_number');
    
                $query->with(['student' => function ($q) {
                    $q->select('id');
                    $q->where('user_type', 'student');
                },
                    'year', 'shift','department','stClass','classGroup','session','section'
                ]);
            }, 'academicResultPrimaryType'])
    
            ->whereIn('student_history_id', $tenStudentIDs)
            ->whereIn('academic_result_primary_type_id', $primary_result_ids)
            ->get();
    
            $grade_list=SiteResultSystemSetting::with(['academicResultSystem'])
                ->where('academic_version_id', $request->academic_version_id)
                ->where('academic_year_id', $request->academic_year_id)
                ->where('academic_class_id', $request->academic_class_id)
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })
                ->where('status', true)
                ->get()
                ->sortBy(function ($item) {
                    return $item->academicResultSystem->serial ?? 0;
                });
    
    
    
            $student_history_ids=$primary_result_list->pluck('student_history_id')->unique()->filter();
    
            $student_array=[];
    
            foreach ($student_history_ids as $key => $value){
    
                $single_student_primary_result_list=$primary_result_list->where('student_history_id', $value)->values();
    
    
                $individual_primary_result_list=[];
                $site_individual_combine_subject_result_store_array=[];
                $result_key=0;

               
                $student_individual_academic_subject_result_list=[];
                $indu_key=0;

                foreach ($CombineResultSettingList as $keys => $values){
    
                    $check_primary_result=$single_student_primary_result_list
                        ->where('academic_result_primary_type_id', $values->academic_result_primary_type_id)
                        ->first();

                    if($check_primary_result){

                    //    dd($check_primary_result);
    
                        $individual_primary_result_list[$result_key]['academic_result_primary_type_id']=$check_primary_result->academic_result_primary_type_id;
                        $individual_primary_result_list[$result_key]['academic_result_primary_type_name']=$check_primary_result->academicResultPrimaryType?$check_primary_result->academicResultPrimaryType->name:'';
                        $individual_primary_result_list[$result_key]['gpa']=$check_primary_result->gpa;
                        $individual_primary_result_list[$result_key]['grade']=$check_primary_result->grade;
                        $individual_primary_result_list[$result_key]['academic_days']=$check_primary_result->academic_days;
                        $individual_primary_result_list[$result_key]['present_days']=$check_primary_result->present_days;
                        $individual_primary_result_list[$result_key]['absent_days']=$check_primary_result->absent_days;
                        $individual_primary_result_list[$result_key]['behaviour']=$check_primary_result->behaviour;
                        $individual_primary_result_list[$result_key]['cultural_activities']=$check_primary_result->cultural_activities;
                        $individual_primary_result_list[$result_key]['bncc']=$check_primary_result->bncc;
                        $individual_primary_result_list[$result_key]['debate']=$check_primary_result->debate;
                        $individual_primary_result_list[$result_key]['scout']=$check_primary_result->scout;
                        $individual_primary_result_list[$result_key]['sports']=$check_primary_result->sports;
                        $individual_primary_result_list[$result_key]['total_student']=$check_primary_result->total_student;
                        $individual_primary_result_list[$result_key]['student_rank']=$check_primary_result->student_rank;
    
                        $result_key++;
    
                        $site_individual_combine_dependant_subject_resul_array=[];
                        $depe_key=0;
                        foreach ($check_primary_result->site_individual_combine_subject_result_store_ids as $keyst => $valuest){
                            $site_individual_combine_subject_result_store_array[]=$valuest;

                           /// dd($valuest);
                            // $site_individual_combine_dependant_subject_resul_array[$depe_key]=$valuest->subject_detail;

                            // $depe_key++;
                               
                            foreach($valuest->subject_detail->indivisual_student_subject_list as $indivisual_student_subject){

                                $obtain_subject_total_marks=$indivisual_student_subject->obtain_subject_total_marks;

                                if($obtain_subject_total_marks>0){
            
                                    $indi_subject_grade=$grade_list
                                    ->where('number_from', '<=', $obtain_subject_total_marks??0)
                                    ->Where('number_to', '>=', $obtain_subject_total_marks??0)
                                    ->first();
                                 
                                }else{
                                    $indi_subject_grade=$grade_list
                                    ->where('number_from', '<=', 0)
                                    ->Where('number_to', '>=',0)
                                    ->first();
                                }

                              //  dd($indivisual_student_subject);
                                $indivisual_student_subject->academic_result_primary_type_id = $check_primary_result->academic_result_primary_type_id;
                                $indivisual_student_subject->point = $indi_subject_grade->point;
                                $indivisual_student_subject->grade = $indi_subject_grade->academicResultSystem->name;
                                $student_individual_academic_subject_result_list[$indu_key]=$indivisual_student_subject;
                                $indu_key++;
                            }
                      
                        }
                    }
                }

       //     dd($student_individual_academic_subject_result_list);

       $exam_dependent_academic_subject_ids=collect($site_individual_combine_subject_result_store_array)
            ->pluck('exam_dependent_academic_subject_id')
            ->unique()
            ->values();
  
    
               $subject_array=[];
               $keysr=0;
               $student_combine_subject_present_status=false;

               foreach ($exam_dependent_academic_subject_ids as  $valuesr){

                $academic_subject=AcademicSubject::findOrFail($valuesr);
        
                $student_individual_academic_subject_ids=collect($student_individual_academic_subject_result_list)
                    ->where('exam_dependent_academic_subject_id',$valuesr)
                    ->pluck('site_subject_group_condition_setting_id')
                    ->unique()
                    ->values();

                if(count($student_individual_academic_subject_ids)>1){
                    $combine_subject_present_status=true;
                    $student_combine_subject_present_status=true;
                }else{
                    $combine_subject_present_status=false;
                }
                    
                $individual_subject_array=[];
                $ind_key=0;
               
                    foreach($student_individual_academic_subject_ids as $ind_key=>$group_condition_setting_id){

                        $GroupConditionSetting=SubjectGroupConditionSetting::findOrFail($group_condition_setting_id);
                    
                        $studentInduvidualAcademicSubject=collect($student_individual_academic_subject_result_list)
                            ->where('exam_dependent_academic_subject_id',$valuesr)
                            ->where('site_subject_group_condition_setting_id',$group_condition_setting_id)
                            ->values();
    
                        //    dd($studentInduvidualAcademicSubject);
    
                       
                        $count_indu_subject=count($studentInduvidualAcademicSubject->where('student_exam_subject_attendance_status',true));
                     //   dd($count_indu_subject);
                        $total_marks_in_term_exam=0;
                        $obtain_subject_total_marks=0;
                        $indi_subject_details=[];
                        foreach($studentInduvidualAcademicSubject as $indi_subject){
                            
                            $total_marks_in_term_exam+=$indi_subject->total_marks_in_term_exam;
                            $obtain_subject_total_marks+=$indi_subject->obtain_subject_total_marks;
                            $indi_subject_details[]=$indi_subject;
                        }
    
                        $primary_result_array=[];
                        foreach($primary_result_ids as $keysss=>$primary_result_id){
                            $primary_type_subject=$studentInduvidualAcademicSubject->where('academic_result_primary_type_id',$primary_result_id)->first();
                           
                            if($primary_type_subject){
                                $primary_result_array[$keysss]=$primary_type_subject;
                              //  dd($primary_result_array);
                            }else{
                                $primary_result_array[$keysss]['academic_result_primary_type_id']=$primary_result_id;
                                $primary_result_array[$keysss]['academic_subject_id']=null;
                                $primary_result_array[$keysss]['obtain_subject_total_marks']='';
                                $primary_result_array[$keysss]['point']='';
                                $primary_result_array[$keysss]['grade']='';

                            }
                        }
    
                 //     dd($primary_result_array);
            
                        if($obtain_subject_total_marks>0){
                            $average_obtain_subject_total_marks=$obtain_subject_total_marks/$count_indu_subject?$count_indu_subject:1;
    
                        }else{
                            $average_obtain_subject_total_marks=$obtain_subject_total_marks;
    
                        }
                       // dd($count_indu_subject);
                        if($average_obtain_subject_total_marks>0){
                
                            $subject_grade=$grade_list
                            ->where('number_from', '<=', $average_obtain_subject_total_marks??0)
                            ->Where('number_to', '>=', $average_obtain_subject_total_marks??0)
                            ->first();
                         
                        }else{
                            $subject_grade=$grade_list
                            ->where('number_from', '<=', 0)
                            ->Where('number_to', '>=',0)
                            ->first();
                        }
    
                       $primary_result_array_count=count(collect($primary_result_array)->where('academic_subject_id',$valuesr));

                       $primary_resul_count=$primary_result_array_count?$primary_result_array_count:1;
            
                        $individual_subject_array[$ind_key]['academic_subject_name']=$GroupConditionSetting->subject_name;
                        $individual_subject_array[$ind_key]['academic_subject_id']=$GroupConditionSetting->academic_subject_id;
                        $individual_subject_array[$ind_key]['site_subject_group_condition_setting_id']=$group_condition_setting_id;
                        $individual_subject_array[$ind_key]['total_exam_mark']=$total_marks_in_term_exam;
                        $individual_subject_array[$ind_key]['average_exam_mark']=$total_marks_in_term_exam/$primary_resul_count;
                        $individual_subject_array[$ind_key]['obtain_subject_total_marks']=$obtain_subject_total_marks;
                        $individual_subject_array[$ind_key]['average_obtain_subject_total_marks']= $this->mathValue($math_condition,$average_obtain_subject_total_marks);
                        $individual_subject_array[$ind_key]['point']= $subject_grade->point;
                        $individual_subject_array[$ind_key]['grade']= $subject_grade->academicResultSystem->name;
                     //   $individual_subject_array[$ind_key]['indi_subject_details']= $indi_subject_details;
    
                    
                    //    dd($primary_result_array);
                     $individual_subject_array[$ind_key]['primary_result_array']= $primary_result_array;
                  
                 
                           
                    }
                
           
              

                    $academic_subject=AcademicSubject::findOrFail($valuesr);
                   
        
                    $subject_list=[];
                    $subject_percent_total_mark=0;
                    $subject_total_mark=0;
                    $subject_total_point=0;
                    $raw_total_marks=0;
                    $total_pass_marks=0;
                    $keysss=0;
                    $count_keysss=0;

                    // subject list
                 
                    foreach($primary_result_ids as $keyss=>$primary_result_id){
                        $single_student_primary_result=$single_student_primary_result_list->where('academic_result_primary_type_id',$primary_result_id)->first();
                        if($single_student_primary_result){
    
                           // dd($single_student_primary_result->site_individual_combine_subject_result_store_ids);
                    //    foreach($dependent_subject_ids as $subject_id){
                        foreach($single_student_primary_result->site_individual_combine_subject_result_store_ids as $subject){

                           
                            if($valuesr==$subject->exam_dependent_academic_subject_id){

                                $subject_list[$keysss]=$subject->toArray();
                                $subject_total_mark+=$subject->obtain_raw_total_marks;
                                $subject_percent_total_mark+=$subject->subject_marks_percentage;
                                $subject_total_point+=$subject->subject_point;
                                $pass_marks=0;
    
    
                                $raw_total_marks=$subject->raw_total_marks;
                                $total_pass_marks=$pass_marks;
                               
                                $keysss++;
                                if($subject->exam_attendance_status){
                                    $count_keysss++;
                                }
                            }
                        }
                    //    }
                    }else{
                        $subject_list[$keysss]['obtain_percent_total_marks']='';
                        $subject_list[$keysss]['obtain_subject_total_marks']='';
                        $subject_list[$keysss]['subject_grade']='';
                        $subject_list[$keysss]['subject_point']='';
                        $subject_list[$keysss]['academic_result_primary_type_id']=$primary_result_id;
                        $subject_list[$keysss]['exam_dependent_academic_subject_id']=$valuesr;
                        $subject_list[$keysss]['subject_base_pass_fail_status']='';
                        $subject_list[$keysss]['subject_count']='';
                       // $subject_list[$keysss]=[];
                       $keysss++;
                      
                       
                    }
    
                 
                    }

                  //  return $subject_list;

                $count_keysss=$count_keysss?$count_keysss:1;
               if($subject_total_mark){
                $average_subject_mark=$this->mathValue($math_condition,$subject_total_mark/$count_keysss);
               }else{
                $average_subject_mark=$subject_total_mark;
               }

               if($subject_percent_total_mark){
                $average_percent_subject_mark= $this->mathValue($math_condition,$subject_percent_total_mark/$count_keysss);
               }else{
                $average_percent_subject_mark=$subject_percent_total_mark;
               }


               if($subject_percent_total_mark){
                $subject_total_point= $this->mathValue($math_condition,$subject_total_point/$count_keysss);
               }else{
                $subject_total_point=$subject_total_point;
               }
              
              // dd($average_percent_subject_mark);
              
                if($average_percent_subject_mark>0){
    
                    $subject_grade=$grade_list
                    ->where('number_from', '<=', $average_percent_subject_mark??0)
                    ->Where('number_to', '>=', $average_percent_subject_mark??0)
                    ->first();
                 
                }else{
                    $subject_grade=$grade_list
                    ->where('number_from', '<=', 0)
                    ->Where('number_to', '>=',0)
                    ->first();
                }

             //   dd($subject_grade);
    
          
    
                \Log::info($value);
              
                $subject_array[$keysr]['combine_subject_present_status']=$combine_subject_present_status;
                $subject_array[$keysr]['raw_total_marks']=$raw_total_marks;
                $subject_array[$keysr]['total_pass_marks']=$total_pass_marks;
                $subject_array[$keysr]['subject_pass_fail_status']=$subject_grade->pass_fail_status;
                $subject_array[$keysr]['subject_point']=$subject_grade->point;
                $subject_array[$keysr]['subject_grade']=$subject_grade->academicResultSystem->name;
                $subject_array[$keysr]['average_subject_mark']=number_format((float) $average_subject_mark, 2, '.', '');
                $subject_array[$keysr]['average_percent_subject_mark']=$average_percent_subject_mark;
                $subject_array[$keysr]['total_subject_mark']=$subject_total_mark;
                $subject_array[$keysr]['primary_result_list']=json_encode($subject_list);
                $subject_array[$keysr]['individual_subject_array']=$individual_subject_array;
                $subject_array[$keysr]['individual_subject_count']=count($individual_subject_array);
                $subject_array[$keysr]['exam_dependent_academic_subject_id']=$valuesr;
                $subject_array[$keysr]['exam_dependent_academic_subject']=$academic_subject->subject_name;
           //     dd($subject_array);
                $keysr++;
                }


    
                $collect_subject_array=collect($subject_array);

                $failed_subject_count=collect($subject_array)->where('subject_pass_fail_status',false)->count();

              
                $average_student_total_mark=$collect_subject_array->sum('average_subject_mark');
               // dd($collect_subject_array);
                $total_student_mark=$collect_subject_array->sum('total_subject_mark');
             //   $total_subject_point=$collect_subject_array->sum('subject_point');
                $average_percent_mark=$collect_subject_array->sum('average_percent_subject_mark')/$keysr;
    
             //   dd($failed_subject_count);
              if(!$failed_subject_count){
                $total_grade=$grade_list
                ->where('number_from', '<=', $average_percent_mark??0)
                ->Where('number_to', '>=', $average_percent_mark??0)
                ->first();
    
                }else{
                    $total_grade=$grade_list
                    ->where('number_from', '<=', 0)
                    ->Where('number_to', '>=',0)
                    ->first();
                }
    
         
           
                 //   dd($individual_primary_result_list);
    
                $student_array[$key]['grade']=$total_grade->academicResultSystem->name;
                $student_array[$key]['point']=$total_grade->point;
                $student_array[$key]['total_student_mark']=$total_student_mark;
                $student_array[$key]['average_student_mark']=$average_student_total_mark/count($collect_subject_array);
                $student_array[$key]['subject_array']=json_encode($subject_array);
                $student_array[$key]['student_history_id']=$value;

    
                $table_header['primary_result_type_list']=$primary_result_type_list;

              
               $checkFinalResult=SiteStudentCombineResultDetail::where('student_history_id',$value)
                    ->where('academic_result_combine_type_id',$combine_result_sett->academic_result_combine_type_id)
                    ->first();
    
                if($checkFinalResult){
                    $checkFinalResult->academic_result_combine_type_id=$combine_result_sett->academic_result_combine_type_id;
                    $checkFinalResult->student_history_id=$value;
                    $checkFinalResult->grade=$total_grade->academicResultSystem->name;
                    $checkFinalResult->gpa=$total_grade->point;
                    $checkFinalResult->total_marks=$total_student_mark;
                    $checkFinalResult->average_percent_total_marks=$average_percent_mark;
                    $checkFinalResult->average_marks= number_format((float) $average_student_total_mark/count($collect_subject_array), 2, '.', '');
                    $checkFinalResult->result_detail=json_encode($subject_array);
                    $checkFinalResult->table_header=json_encode($table_header);
                    $checkFinalResult->individual_primary_result_list=json_encode($individual_primary_result_list);
                    $checkFinalResult->combine_subject_present_status=$student_combine_subject_present_status;
                    $checkFinalResult->save();
    
                }else{
    
                    $combine_result=new SiteStudentCombineResultDetail;
    
                    $combine_result->academic_result_combine_type_id=$combine_result_sett->academic_result_combine_type_id;
                    $combine_result->student_history_id=$value;
                    $combine_result->grade=$total_grade->academicResultSystem->name;
                    $combine_result->gpa=$total_grade->point;
                    $combine_result->total_marks=$total_student_mark;
                    $combine_result->average_percent_total_marks=$average_percent_mark;

                //    $combine_result->average_marks=$average_student_total_mark;
                    $combine_result->average_marks= number_format((float) $average_student_total_mark/count($collect_subject_array), 2, '.', '');
                    $combine_result->result_detail=json_encode($subject_array);
                    $combine_result->table_header=json_encode($table_header);
                    $combine_result->individual_primary_result_list=json_encode($individual_primary_result_list);
                    $combine_result->save();
                }
    
            
            }
    
            $count_student=count($classAllStudentlist);
            $completed_percent=ceil(count($generatedStudentIDs)*100/$count_student);
    
        
            if(count($tenStudentIDs)>0){
    
            // $combineResultDetail=SiteStudentCombineResultDetail::whereIn('student_history_id',$studentIdsList)
            //     ->where('academic_result_combine_type_id',$combine_result_sett->academic_result_combine_type_id)
            //     ->orderBy('gpa','DESC')
            //     ->orderBy('total_marks','DESC')
            //     ->get();
    
            //     $rank=1;
            // foreach($combineResultDetail as $result){
    
            //     $result->student_rank=$rank;
            //     $result->save();
            //     $rank++;
                
            // }
    
                return response()->json(
                    [
                        'generatedStudentIDs'=>$generatedStudentIDs,
                        'count_student'=>$count_student,
                        'completed_percent'=>$completed_percent,
                    ]);
    
            }else{
                return Response::json(['message' => 'information Save Successfully!', 'mode' => 'Saved!'], 200);
            }
    
          
        }
        

}